/*
 * Decompiled with CFR 0.152.
 */
package jclass.cell.renderers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Vector;
import jclass.cell.CellInfo;
import jclass.cell.CellRenderer;
import jclass.cell.Utilities;
import jclass.util.JCString;

public class ButtonCellRenderer
implements CellRenderer {
    protected boolean enabled = true;
    protected int border_style = 9;
    protected Object arm_value;
    protected boolean armed = false;
    protected int highlight;
    protected int border = 2;
    protected int arm_offset = 1;

    public void draw(Graphics graphics, CellInfo cellInfo, Object object, boolean bl) {
        Object object2 = null;
        Rectangle rectangle = cellInfo.getDrawingArea();
        Utilities.translateToWholeCell(graphics, cellInfo, rectangle);
        cellInfo.getFontMetrics();
        graphics.setFont(cellInfo.getFont());
        graphics.setColor(bl ? cellInfo.getSelectedForeground() : cellInfo.getForeground());
        int n = cellInfo.getHorizontalAlignment();
        Utilities.drawBorder(graphics, this.border_style, this.border, this.highlight, this.highlight, rectangle.width - 2 * this.highlight, rectangle.height - 2 * this.highlight, cellInfo.getBackground(), cellInfo.getForeground());
        if (this.armed && this.arm_value != null) {
            graphics.translate(this.arm_offset, this.arm_offset);
            object2 = this.arm_value;
        } else {
            if (this.armed) {
                graphics.translate(this.arm_offset, this.arm_offset);
            }
            object2 = object;
        }
        if (this.armed) {
            graphics.translate(-this.arm_offset, -this.arm_offset);
        }
        Insets insets = cellInfo.getBorderInsets();
        Insets insets2 = cellInfo.getMarginInsets();
        Rectangle rectangle2 = cellInfo.getDrawingArea();
        rectangle2.setLocation(insets.right + insets2.right, insets.top + insets2.top);
        if (!this.enabled) {
            Color color = graphics.getColor();
            graphics.translate(1, 1);
            graphics.setColor(Color.white);
            ButtonCellRenderer.draw_label(null, graphics, object2, n, cellInfo.getVerticalAlignment(), rectangle2);
            graphics.translate(-1, -1);
            graphics.setColor(cellInfo.getBackground().darker());
            ButtonCellRenderer.draw_label(null, graphics, object2, n, cellInfo.getVerticalAlignment(), rectangle2);
            graphics.setColor(color);
        } else {
            ButtonCellRenderer.draw_label(null, graphics, object2, n, cellInfo.getVerticalAlignment(), rectangle2);
        }
        Utilities.restoreFromWholeCell(graphics, cellInfo, rectangle);
    }

    public Dimension getPreferredSize(CellInfo cellInfo, Object object) {
        int n = ButtonCellRenderer.getWidth(object, null, cellInfo.getFont());
        int n2 = ButtonCellRenderer.getHeight(object, null, cellInfo.getFont());
        return new Dimension(n + cellInfo.getMarginInsets().right * 2 + cellInfo.getBorderInsets().right * 2, n2 + cellInfo.getMarginInsets().top * 2 + cellInfo.getBorderInsets().top * 2);
    }

    public static void draw_label(Component component, Graphics graphics, Object object, int n, int n2, Rectangle rectangle) {
        int n3;
        if (object == null) {
            return;
        }
        if (object instanceof JCString) {
            ((JCString)object).draw(component, graphics, rectangle, n);
            return;
        }
        if (object instanceof Image) {
            graphics.drawImage((Image)object, rectangle.x, rectangle.y, null);
            return;
        }
        String string = object.toString();
        if (string == null || string.length() == 0) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Font font = graphics.getFont();
        int n4 = fontMetrics.getHeight();
        int n5 = 0;
        int n6 = n4 - fontMetrics.getAscent();
        int n7 = rectangle.y + n4 - n6;
        int n8 = n3 = n2 == 0 ? 0 : ButtonCellRenderer.getHeight(string, component, font);
        if (n2 == 2) {
            n7 += rectangle.height - n3;
        } else if (n2 == 1) {
            n7 += (rectangle.height - n3) / 2;
        }
        if (string.indexOf(10) != -1) {
            String string2;
            int n9;
            int n10 = 0;
            while ((n9 = string.indexOf(10, n10)) != -1) {
                string2 = string.substring(n10, n9);
                if (n == 1) {
                    n5 = (rectangle.width - ButtonCellRenderer.stringWidth(fontMetrics, font, string2)) / 2;
                } else if (n == 2) {
                    n5 = rectangle.width - ButtonCellRenderer.stringWidth(fontMetrics, font, string2);
                }
                graphics.drawString(string2, rectangle.x + n5, n7);
                n10 = n9 + 1;
                n7 += n4;
            }
            string2 = string.substring(n10, string.length());
            if (n == 1) {
                n5 = (rectangle.width - ButtonCellRenderer.stringWidth(fontMetrics, font, string2)) / 2;
            } else if (n == 2) {
                n5 = rectangle.width - ButtonCellRenderer.stringWidth(fontMetrics, font, string2);
            }
            graphics.drawString(string2, rectangle.x + n5, n7);
            return;
        }
        if (n == 1) {
            n5 = (rectangle.width - ButtonCellRenderer.stringWidth(fontMetrics, font, string)) / 2;
        } else if (n == 2) {
            n5 = rectangle.width - ButtonCellRenderer.stringWidth(fontMetrics, font, string);
        }
        graphics.drawString(string, rectangle.x + n5, n7);
    }

    public static int getWidth(Object object, Component component) {
        return ButtonCellRenderer.getWidth(object, component, component.getFont());
    }

    public static int getWidth(Object object, Component component, Font font) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Image) {
            return ((Image)object).getWidth(null);
        }
        if (object instanceof JCString) {
            return ((JCString)object).getWidth(component, font);
        }
        if (object instanceof Vector) {
            int n = 0;
            int n2 = 0;
            while (n2 < ((Vector)object).size()) {
                n += ButtonCellRenderer.getWidth(((Vector)object).elementAt(n2), component);
                ++n2;
            }
            return n;
        }
        String string = object.toString();
        if (string == null || string.length() == 0) {
            return 0;
        }
        if (component == null || component.getToolkit() == null || font == null) {
            return 0;
        }
        FontMetrics fontMetrics = component.getToolkit().getFontMetrics(font);
        if (string.indexOf(10) != -1) {
            int n;
            int n3 = 0;
            int n4 = 0;
            while ((n = string.indexOf(10, n3)) != -1) {
                n4 = Math.max(n4, ButtonCellRenderer.stringWidth(fontMetrics, font, string.substring(n3, n)));
                if (font.isItalic()) {
                    n4 += 5;
                }
                n3 = n + 1;
            }
            return Math.max(n4, ButtonCellRenderer.stringWidth(fontMetrics, font, string.substring(n3, string.length())));
        }
        return ButtonCellRenderer.stringWidth(fontMetrics, font, string);
    }

    static int stringWidth(FontMetrics fontMetrics, Font font, String string) {
        return fontMetrics.stringWidth(string) + (font.isItalic() ? font.getSize() / 3 + 1 : 0);
    }

    public static int getHeight(Object object, Component component) {
        return ButtonCellRenderer.getHeight(object, component, component.getFont());
    }

    public static int getHeight(Object object, Component component, Font font) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Image) {
            return ((Image)object).getHeight(null);
        }
        if (object instanceof JCString) {
            return ((JCString)object).getHeight(component, font);
        }
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            int n = 0;
            int n2 = 0;
            while (n2 < vector.size()) {
                n = Math.max(n, ButtonCellRenderer.getHeight(vector.elementAt(n2), component, font));
                ++n2;
            }
            return n;
        }
        if (component == null || component.getToolkit() == null || font == null) {
            return 0;
        }
        return component.getToolkit().getFontMetrics(font).getHeight() * ButtonCellRenderer.getNumLines(object.toString());
    }

    private static int getNumLines(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        int n = 1;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\n') {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public static int getNumLines(Object object) {
        return ButtonCellRenderer.getNumLines(ButtonCellRenderer.toString(object));
    }

    static String toString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Image) {
            return null;
        }
        if (object instanceof JCString) {
            return ((JCString)object).getString();
        }
        if (object instanceof Vector) {
            int n = 0;
            while (n < ((Vector)object).size()) {
                String string = ButtonCellRenderer.toString(((Vector)object).elementAt(n));
                if (string != null) {
                    return string;
                }
                ++n;
            }
            return null;
        }
        return object.toString();
    }
}

